/*
 * LoginAction.java Created on June 6, 2005, 8:34 AM
 */
package live.struts.actions;
import org.apache.struts.action.ActionForward;

import live.dto.Network;
import live.threads.SequentialRunner;
import live.threads.ParallelRunner;
import live.threads.ThreadedUserAction;
import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Deletes the network specified by the request parameter netName
 */
public class DeleteNetworkAction extends SwitchedAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		String netName = info.getRequestParameter("netName");

		info.setRequestAttribute(Attributes.confirmation.message,
				"You are about to delete the network " + netName
						+ ". Are you sure you wish to proceed?");
		info.setRequestAttribute(Attributes.confirmation.accept_message,
				"Yes, delete " + netName);

		return info.findForward(Mappings.networks.deletePage.confirm);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		String netName = info.getRequestParameter("netName");

		SequentialRunner mainThread = new SequentialRunner(info.threadInfo,
				"Delete network " + netName);
		
		ParallelRunner disconnections = new ParallelRunner(info.threadInfo,
				"Disconnect members");

		// We delete a network by removing everyone from it. So we have to
		// find out who is in it first.
		ThreadedZVMTasks.QueryNetworkMembers thread = 
			new ThreadedZVMTasks.QueryNetworkMembers(info.threadInfo, netName);
		thread.startJoinForever();

		// Then we iterate through the members...
		
		Network net = (Network) thread.rawResult();
		
		java.util.Iterator iter = net.getMembers().iterator();
		while(iter.hasNext())
		{
			String guestName = (String)iter.next();
			
			// ... and a delete/disconnect request to the main runner
			ThreadedUserAction thisGuest = new ThreadedZVMTasks.VSwitchDetatch(
					info.threadInfo, netName, guestName);
			disconnections.schedule(thisGuest);
		}

		ThreadedUserAction delete = new ThreadedZVMTasks.VSwitchDelete(info.threadInfo, netName);
		
		mainThread.schedule(disconnections);
		mainThread.schedule(delete);
		
		mainThread.startJoinTimeout(Util.TIMEOUT_MS);

		return info.smartForward(thread, Mappings.networks.list.This);
		
		/*if(mainThread.isFinished())
		{
			if(mainThread.getException() == null)
				return Mappings.networks.list.This;
			else
			{
				info.setRequestAttribute(Attributes.error.message, 
						"There was an error with your request: " +
						mainThread.getException().getMessage());
				
				return Mappings.guests.list.error;
			}
		}
		else
			return Mappings.networks.deletePage.timeout;*/
	}

}