package live.struts.actions;
import org.apache.struts.action.ActionForward;

import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * This action will delete a guest as specified in the ActionInfo request parameter guestName
 */
public class DeleteGuestAction extends SwitchedAction
{
    /**
     * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward performAction(CheckedAction.ActionInfo info)
    {
	//get info needed
	String guestName = info.getRequestParameter("guestName");
	
	//Delete guest from server
	ThreadedZVMTasks.DeleteGuest thread = 
			new ThreadedZVMTasks.DeleteGuest(info.threadInfo, guestName);
	thread.startJoinTimeout(Util.TIMEOUT_MS);
	
	return info.smartForward(thread, Mappings.guests.list.This);
    }

    /**
     * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward displayPage(CheckedAction.ActionInfo info)
    {
	String guestName = info.getRequestParameter("guestName");

	info.setRequestAttribute(Attributes.confirmation.message, "You are about to delete the guest " + guestName + ". Are you sure you wish to proceed?");
	info.setRequestAttribute(Attributes.confirmation.accept_message, "Yes, delete " + guestName);

	return info.findForward(Mappings.guests.deletePage.confirm);
    }
}
