/*
 * Created on Jul 7, 2005
 */
package live.struts.actions;

import java.util.Iterator;

import org.apache.struts.action.ActionForward;

import live.threads.ThreadedUserAction;
import live.threads.ThreadedZVMTasks;
import live.dto.Guest;
import live.threads.ParallelRunner;
import live.threads.SequentialRunner;
import live.threads.Runner;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * This class deletes or destroys the group specified by the
 * request parameter groupName, depending on the value of deleteOrDestroy.
 * 
 * @author Evan Driscoll
 */
public class DeleteGroupAction extends SwitchedAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		String groupName = info.getRequestParameter("groupName");
		String destroyOrDelete = info.getRequestParameter("deleteOrDestroy");
		boolean destroying = destroyOrDelete.equalsIgnoreCase("destroy");
		
		if(destroying)
		{
			info.setRequestAttribute(Attributes.confirmation.message,
							"You are about to destroy the group " + groupName +
							"! This will remove the group and delete all of " +
							"the images within! If you just want to remove " +
							"the group and move the images into ungrouped, " +
							"this is NOT what you want! Are you sure you want " +
							"to do this?");
			info.setRequestAttribute(Attributes.confirmation.accept_message,
					"Yes, delete all the images in " + groupName);
			info.setRequestAttribute("groupName", groupName);
		}
		else
		{
			info.setRequestAttribute(Attributes.confirmation.message,
					"You are about to delete the group " + groupName +
					". This will move all the guests currently in " +
					groupName + " to the ungrouped category. Are you " +
					"sure you want to do this?");
			info.setRequestAttribute(Attributes.confirmation.accept_message,
					"Yes, delete the group " + groupName);
			info.setRequestAttribute("groupName", groupName);
		}

		return info.findForward(Mappings.guests.destroyGroup.confirm);
	}
	
	
	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		String groupName = info.getRequestParameter("groupName");
		String destroyOrDelete = info.getRequestParameter("deleteOrDestroy");
		boolean destroying = destroyOrDelete.equalsIgnoreCase("destroy");
		
		Runner mainThread = new ParallelRunner(info.threadInfo,
				(destroying ? "Destroying" : "Deleting") + " group " + groupName);


		Iterator iter = info.cache.getGuestsInGroup(groupName).iterator();
		while(iter.hasNext())
		{
			Guest guest = (Guest)iter.next();
			// foreach(guest in the group we are destroying)

			String guestName = guest.getGuestName();
			String currentGroup = guest.getGroupName();

			// We have thread objects for both the removal and deletion
			// Note that we create these objects no matter whether we are deleting
			// or destroying; we just won't use anything but the remove if we are
			// just deleting.
			ThreadedUserAction remove = new ThreadedZVMTasks.SetGuestToGroup(
					info.threadInfo, guestName, currentGroup, null);
			ThreadedUserAction delete = new ThreadedZVMTasks.DeleteGuest(
					info.threadInfo, guest.getGuestName());
			
			// Then a runner that will run each of those in sequence
			SequentialRunner thisGuest = new SequentialRunner(info.threadInfo,
					"Remove and delete " + guest);
			
			thisGuest.schedule(delete);
			thisGuest.schedule(remove);
			
			// Here's where we distinguish between deleting and destroying
			if(destroying)
				mainThread.schedule(thisGuest);
			else
				mainThread.schedule(remove);
		}

		mainThread.startJoinTimeout(Util.TIMEOUT_MS);

		return info.smartForward(mainThread, Mappings.guests.list.This);
	}
}
