package live.struts.actions;

import live.threads.ParallelRunner;
import live.threads.ThreadedZVMTasks;

import java.util.LinkedList;
import java.util.ListIterator;

import org.apache.struts.action.ActionForward;

import live.constants.Mappings;
import live.constants.Attributes;

/**
 *  This is the action for deactivating a whole group
 */
public class DeactivateGroupAction extends SwitchedAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		String groupName = info.getRequestParameter("groupName");

		info.setRequestAttribute(Attributes.confirmation.message,
				"You are about to deactivate all the guests in " + groupName
						+ ". Are you sure you wish to proceed?");
		info.setRequestAttribute(Attributes.confirmation.accept_message,
				"Yes, deactivate group " + groupName);

		return info.findForward(Mappings.guests.deletePage.confirm);
	}
	
	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		//get info needed
		String groupName = info.getRequestParameter("groupName");

		//Get that group.
		LinkedList guestsToActivate = info.cache.getGuestNamesInGroup(groupName);
		
		ParallelRunner activateThreads = new 
			ParallelRunner(info.threadInfo, "Deactivating group " + groupName,  3);
		
		//Create guest activates threads and add all to the runner.
		ThreadedZVMTasks.ImageDeactivate actThread;
		ListIterator itr = guestsToActivate.listIterator();
		while(itr.hasNext())
		{
		    actThread = new ThreadedZVMTasks.ImageDeactivate(info.threadInfo, 
								    (String)itr.next());
		    activateThreads.schedule(actThread);
		}
		
		boolean isDone = activateThreads.startJoinTimeout(Util.TIMEOUT_MS);

		if(!isDone)
		{
			info.setRequestAttribute("link", "Were still waiting :)");
			return info.findForward(Mappings.guests.list.This);
		}
		
		
		return info.smartForward(activateThreads, Mappings.guests.list.This);
	}
}
