/*
 * ChangeSharedStorageMembers.java
 * Created on August 3, 2005, 11:59 AM
 */
package live.struts.actions;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.HashSet;

import org.apache.struts.action.ActionForward;

import live.threads.ParallelRunner;
import live.threads.SequentialRunner;
import live.threads.Runner;
import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * This action will change the guests who have access to a shared storage segment
 */
public class ChangeSharedStorageMembers extends SwitchedAction
{
    /**
     * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward displayPage(ActionInfo info)
    {
	String segName = info.getRequestParameter("segName");

		// Get the current members
		ThreadedZVMTasks.SharedStorageAccessQueryNameList thread = 
			new ThreadedZVMTasks.SharedStorageAccessQueryNameList(info.threadInfo, segName);
		
		thread.startJoinForever();
		Object rawResult = thread.rawResult();
		
		if(rawResult instanceof Exception)
		{
		    info.setRequestAttribute("errorMessage", ((Exception)rawResult).getMessage());
		    return info.findForward(Mappings.sharedSegments.info.error);
		}

		LinkedList members = (LinkedList)thread.rawResult();

		//members is a list of Strings, we need a set of Strings.
		HashSet memberSet = new HashSet();
		ListIterator itr = members.listIterator();
		while(itr.hasNext())
		{
		    memberSet.add(itr.next());
		}
		
		// The members are checked by default
		info.setRequestAttribute(
				Attributes.networks.chMembers.checkByDefault_OPT, memberSet);
		
		// And this is the list of all guests
		info.setRequestAttribute(Attributes.networks.chMembers.groupList,
				info.cache.getGroups());

		return info.findForward(Mappings.sharedSegments.chMembers.DisplayPage);
    }
    
    /**
     * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
     */
    public ActionForward performAction(ActionInfo info)
    {
	
		String segName = info.getRequestParameter("segName");

		HashSet shouldBeInSeg = Util.getUserSelectedGuestNames(info.request);

		// We need the members that currently have access to the segment
		ThreadedZVMTasks.SharedStorageAccessQueryNameList thread = 
			new ThreadedZVMTasks.SharedStorageAccessQueryNameList( info.threadInfo, segName);
		thread.startJoinForever();
		
		Object rawResult = thread.rawResult();
		
		if(rawResult instanceof Exception)
		{
		    info.setRequestAttribute("errorMessage", ((Exception)rawResult).getMessage());
		    return info.findForward(Mappings.sharedSegments.info.error);
		}

		LinkedList members = (LinkedList)thread.rawResult();

		//members is a list of Strings, we need a set of Strings.
		HashSet currentlyInSeg = new HashSet();
		ListIterator itr = members.listIterator();
		while(itr.hasNext())
		{
		    currentlyInSeg.add(itr.next());
		}
		
		// Images we want to add are ones that should be in the segment
		// but are not currently
		HashSet imageNamesToAdd = (HashSet)shouldBeInSeg.clone();
		imageNamesToAdd.removeAll(currentlyInSeg);

		// Images te want to remove are ones that are currently in the 
		// network but shouldn't be
		HashSet imageNamesToRemove = (HashSet)currentlyInSeg.clone();
		imageNamesToRemove.removeAll(shouldBeInSeg);

		Runner mainThread = new SequentialRunner(info.threadInfo,
				"Adding members to " + segName);
		
		Runner additions = new ParallelRunner(info.threadInfo,
				"Adding members");

		// Add all the images to add
		tellThreadAboutConnections(imageNamesToAdd, info, additions, segName);
		tellThreadAboutDisconnections(imageNamesToRemove, info, additions, segName);
		
		mainThread.schedule(additions);
		
		mainThread.startJoinTimeout(Util.TIMEOUT_MS);
		
		return info.smartForward(mainThread, Mappings.sharedSegments.list.OK);
    }
    
    private void tellThreadAboutConnections(HashSet users,
			CheckedAction.ActionInfo info, Runner runner, String segName)
	{
		java.util.Iterator iter = users.iterator();
		while(iter.hasNext())
		{
			String guestName = (String)iter.next();
			// foreach(guestName in users)
			
			ThreadedZVMTasks.SharedStorageAccessAdd a;
			
			a = new ThreadedZVMTasks.SharedStorageAccessAdd(
					info.threadInfo, guestName, segName);

			runner.schedule(a);
		}
	}
	
	
	private void tellThreadAboutDisconnections(HashSet users,
			CheckedAction.ActionInfo info, Runner runner, String segName)
	{
		java.util.Iterator iter = users.iterator();
		while(iter.hasNext())
		{
			String guestName = (String)iter.next();
			// foreach(guestName in users)
			
			ThreadedZVMTasks.SharedStorageAccessRemove a = 
				new ThreadedZVMTasks.SharedStorageAccessRemove(info.threadInfo, guestName, segName);
			
			runner.schedule(a);
		}
	}
}
