/*
 * Created on Jul 20, 2005
 */
package live.struts.actions;

import org.apache.struts.action.ActionForward;

import live.constants.Mappings;
import live.threads.ThreadedZVMTasks;

import live.struts.forms.GuestNamePassForm;

/**
 * This action changes a guest's password
 * @author Evan Driscoll
 */
public class ChangePassword extends SwitchedAction
{

	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(ActionInfo info)
	{
		info.setRequestAttribute("guestName", info.getRequestParameter("guestName"));
		return info.findForward(Mappings.guests.chPass.showPage);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(ActionInfo info)
	{
		GuestNamePassForm form =(GuestNamePassForm) info.form; 
		
		String guestName = form.getGuestName();
		String newPassword = form.getPassword();
		
		ThreadedZVMTasks.ChangePassword a = 
			new ThreadedZVMTasks.ChangePassword(
					info.threadInfo, guestName, newPassword); 
		
		a.startJoinTimeout(Util.TIMEOUT_MS);
		
		return info.smartForward(a, Mappings.guests.info.This);
	}

}
