/*
 * Created on Jul 11, 2005
 */
package live.struts.actions;

import java.util.HashSet;
import java.util.TreeSet;

import org.apache.struts.action.ActionForward;

import live.dto.Network;
import live.threads.ParallelRunner;
import live.threads.SequentialRunner;
import live.threads.Runner;
import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action for changing the members of a network
 * @author Evan Driscoll
 */
public class ChangeNetworkMembers extends SwitchedAction
{

	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(ActionInfo info)
	{
		String netName = info.getRequestParameter("netName");

		// Get the current members
		ThreadedZVMTasks.QueryNetworkMembers thread = 
			new ThreadedZVMTasks.QueryNetworkMembers(info.threadInfo, netName);
		thread.startJoinForever();

		// Make a set of the members (since QueryNetworkMembers returns a LinkedList)
		TreeSet members = new TreeSet(((Network)thread.rawResult()).getMembers());

		// The members are checked by default
		info.setRequestAttribute(
				Attributes.networks.chMembers.checkByDefault_OPT, members);
		
		// And this is the list of all guests
		info.setRequestAttribute(Attributes.networks.chMembers.groupList,
				info.cache.getGroups());

		return info.findForward(Mappings.networks.chMembers.DisplayPage);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(ActionInfo info)
	{
		String netName = info.getRequestParameter("netName");

		HashSet shouldBeInNetwork = Util.getUserSelectedGuestNames(info.request);

		// We need the members that are currently in the network
		ThreadedZVMTasks.QueryNetworkMembers thread = new ThreadedZVMTasks.QueryNetworkMembers(
				info.threadInfo, netName);
		thread.startJoinForever();

		HashSet currentlyInNetwork = new HashSet(((Network)thread.rawResult())
				.getMembers());

		// Images we want to add are ones that should be in the network
		// but are not currently
		HashSet imageNamesToAdd = (HashSet)shouldBeInNetwork.clone();
		imageNamesToAdd.removeAll(currentlyInNetwork);

		// Images te want to remove are ones that are currently in the 
		// network but shouldn't be
		HashSet imageNamesToRemove = (HashSet)currentlyInNetwork.clone();
		imageNamesToRemove.removeAll(shouldBeInNetwork);

		Runner mainThread = new SequentialRunner(info.threadInfo,
				"Adding members to " + netName);
		
		Runner additions = new ParallelRunner(info.threadInfo,
				"Adding members");

		ThreadedZVMTasks.FindCommonFreeAddress addy =
			new ThreadedZVMTasks.FindCommonFreeAddress(info.threadInfo, null);
		
		mainThread.schedule(addy);
		
		// Add all the images to add
		tellThreadAboutConnections(imageNamesToAdd, info, additions, netName, addy);
		tellThreadAboutDisconnections(imageNamesToRemove, info, additions, netName);
		
		mainThread.schedule(additions);
		
		mainThread.startJoinTimeout(Util.TIMEOUT_MS);
		
		return info.smartForward(mainThread, Mappings.networks.list.This);
	}

	///////////////// HELPER FUNCTIONS ///////////////////////

	// TODO: these can be combined
	
	/**
	 * This thread adds a connection request for everyone who isn't
	 * connected and should be.
	 *
	 * @param users HashSet of guest names to connect.
	 * @param info Action information for this action.
	 * @param runner What we use to schedule the thread.
	 * @param netName Network name to connect people to.
	 * @param addySource The lowest common free address for all 
	 *    the members we're adding to the network
	 */
	private void tellThreadAboutConnections(HashSet users,
			CheckedAction.ActionInfo info, Runner runner, String netName,
			ThreadedZVMTasks.FindCommonFreeAddress addySource)
	{
		java.util.Iterator iter = users.iterator();
		while(iter.hasNext())
		{
			String guestName = (String)iter.next();
			// foreach(guestName in users)
			
			// This is the address they should be connected to
			String vAddress = info.getRequestParameter("ADDRESS_" + guestName);
			
			ThreadedZVMTasks.VSwitchCreateConnect a;
			
			if(vAddress!=null && !vAddress.equals(""))
			{
				a = new ThreadedZVMTasks.VSwitchCreateConnect(
						info.threadInfo, netName, null, null, guestName, vAddress);
			}
			else
			{
				addySource.addSource(guestName);
				a = new ThreadedZVMTasks.VSwitchCreateConnect(
						info.threadInfo, netName, null, null, guestName, addySource);
			}

			runner.schedule(a);
		}
	}
	
	/**
	 * This thread adds a detach request for everyone who is connected and
	 *   shouldn't be
	 * @param users HashSet of guest names to detach.
	 * @param info Action information.
	 * @param runner What we need to schedule this thread.
	 * @param netName Name of network to detach from.
	 */
	private void tellThreadAboutDisconnections(HashSet users,
			CheckedAction.ActionInfo info, Runner runner, String netName)
	{
		java.util.Iterator iter = users.iterator();
		while(iter.hasNext())
		{
			String guestName = (String)iter.next();
			// foreach(guestName in users)
			
			ThreadedZVMTasks.VSwitchDetatch a = 
				new ThreadedZVMTasks.VSwitchDetatch(info.threadInfo, netName, guestName);
			
			runner.schedule(a);
		}
	}

}
