package live.struts.actions;

import org.apache.struts.action.ActionForward;

import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;

import live.struts.forms.ChMemoryForm;

/**
 * This is the action for changing a guest's memory (not minidisks)
 */
public class ChangeMemoryAction extends SwitchedAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		ChMemoryForm form = (ChMemoryForm) info.form;
		
		//get info needed
		String guestName = info.getRequestParameter("guestName");	
		String initMem = form.getDefaultMemory();
		String maxMem = form.getMaximumMemory();

		
		ThreadedZVMTasks.ChangeMemory thread = 
			new ThreadedZVMTasks.ChangeMemory(info.threadInfo, guestName, initMem, maxMem);
		
		thread.startJoinTimeout(Util.TIMEOUT_MS);
		
		return info.smartForward(thread, Mappings.guests.list.This);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		info.setRequestAttribute("guestName", info.getRequestParameter("guestName"));
		return info.findForward(Mappings.guests.chMem.showPage);
	}
}
