/*
 * Created on Jul 6, 2005
 */
package live.struts.actions;

import org.apache.struts.action.ActionForward;

import live.constants.Attributes;
import live.constants.Mappings;
import live.dto.Group;
import live.struts.forms.ChGuestsGroupForm;
import live.threads.ThreadedZVMTasks;
import live.threads.ThreadedUserAction;

/**
 * This action changes the group a specific guest belongs to, as opposed to
 * changing the guests that are in a specific group.
 * 
 * @author Evan Driscoll
 */
public class ChangeAGuestsGroupAction extends SwitchedAction
{
	/** 
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		String guestName = info.getRequestParameter("guestName");
		String groupName = info.cache.getGuest(guestName).getGroupName();

		info.setRequestAttribute(Attributes.guests.changeGuestsGroup.guestname,
				guestName);
		
		info.setRequestAttribute(Attributes.guests.changeGuestsGroup.guestList,
				info.cache.getGroupNames());
		
		info.setRequestAttribute(
				Attributes.guests.changeGuestsGroup.currentGroup, groupName);
		
		ChGuestsGroupForm form = new ChGuestsGroupForm();
		form.setGroupName(groupName);
		info.setRequestAttribute("GrpChangeForm", form);

		// Forward to the page
		return info.findForward(Mappings.guests.chGuestsGroupPage.list);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		ChGuestsGroupForm form = (ChGuestsGroupForm) info.form;
		
		String guestName = info.getRequestParameter("guestName");
		
		String newGroup = form.getGroupName();
		
		live.dto.Guest guest = info.cache.getGuest(guestName);
		String currentGroup = guest.getGroupName();

		// Here we have to use equals instead of == because newGroup comes
		// in as a request parameter, and the servlet knows nohing of our
		// grouping scheme and Group.UNGROUPED_NAME.
		if(newGroup.equals(Group.UNGROUPED_NAME))
			newGroup = null;

		
		//info.setRequestAttribute(Attributes.guests.changeGuestsGroup.guestname,
		//		guestName);

		ThreadedUserAction thread = new ThreadedZVMTasks.SetGuestToGroup(
				info.threadInfo, guestName, currentGroup, newGroup);
		thread.startJoinTimeout(Util.TIMEOUT_MS);

		return info.smartForward(thread, Mappings.guests.info.This);
	}
}
