/**
 * Created on Jul 29, 2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
package live.struts.actions;

import java.util.LinkedList;

import org.apache.struts.action.ActionForward;

import live.constants.Attributes;
import live.constants.Mappings;
import live.threads.ParallelRunner;
import live.threads.SequentialRunner;
import live.threads.ThreadedZVMTasks;
import live.threads.ThreadedZVMTasks.FindCommonFreeAddress;

/**
 * Action to change a guest's minidisks
 * @author Evan Driscoll
 */
public class ChMinidisks extends SwitchedAction
{

	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(ActionInfo info)
	{
		String guestName = info.getRequestParameter("guestName");
		
		ThreadedZVMTasks.QueryMinidisks query = 
			new ThreadedZVMTasks.QueryMinidisks(info.threadInfo, guestName);
		
		query.startJoinForever();
		
		LinkedList disks = (LinkedList) query.rawResult();
		
		info.setRequestAttribute(Attributes.guests.chMinidisks.diskList, disks);
		
		info.setRequestAttribute("guestName", info.getRequestParameter("guestName"));
		
		return info.findForward(Mappings.guests.ViewMinidisks.showPage);
	}
	
	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(ActionInfo info)
	{
		String guestName = info.getRequestParameter("guestName");
		
		String removeString = info.getRequestParameter("diskAddressesToRemove");
		
		String[] diskAddressesToRemove = removeString.split("\\|");
		
		ParallelRunner mainThread = new ParallelRunner(info.threadInfo, 
				"Adding and removing minidisks to " + guestName,
				2);
		
		// We start at 1 because 0 is used in the HTML as a model
		// and is never displayed to the user let alone filled out
		for(int i=0; i<diskAddressesToRemove.length ; ++i)
		{
			if(diskAddressesToRemove[i].equals("")) continue;
			
			ThreadedZVMTasks.DeleteMinidisk del = 
				new ThreadedZVMTasks.DeleteMinidisk(info.threadInfo, 
						guestName, diskAddressesToRemove[i]);
			
			mainThread.schedule(del);
		}
		
		for(int i=0 ; ; ++i)
		{
			String virtualAddress = info.getRequestParameter("ADDR_"  + i);
			if(virtualAddress == null)
				break;
			
			Object address;
			if(virtualAddress.equals(""))
				address = 
					(new ThreadedZVMTasks.FindCommonFreeAddress(info.threadInfo, null))
					.addSource(guestName);
			else
				address = virtualAddress;
				
			
			String size = info.getRequestParameter("SIZE_" + i);
			if("".equals(size))
				continue;
			
			String type = info.getRequestParameter("TYPE_" + i);
			String mode = info.getRequestParameter("MODE_" + i);
			String readPW = info.getRequestParameter("READPW_" + i);
			String writePW = info.getRequestParameter("WRITEPW_" + i);
			String multiPW = info.getRequestParameter("MULTIPW_" + i);
			
			ThreadedZVMTasks.CreateMinidisk create =
				new ThreadedZVMTasks.CreateMinidisk(info.threadInfo,
						guestName, address, type,
						size, mode, readPW, writePW, multiPW);

			if(address instanceof FindCommonFreeAddress)
			{
				SequentialRunner r = 
					new SequentialRunner(info.threadInfo, "Adding a minidisk");
				r.schedule((FindCommonFreeAddress) address);
				r.schedule(create);
				mainThread.schedule(r);
			}
			else
			{
				mainThread.schedule(create);
			}
		}
		
		mainThread.startJoinTimeout(Util.TIMEOUT_MS);
		
		return info.smartForward(mainThread, Mappings.guests.info.This);
	}

}
