/*
 * ActivateGuestAction.java Created on July 14, 2005, 7:13 AM
 */
package live.struts.actions;
import org.apache.struts.action.ActionForward;

import live.threads.ThreadedZVMTasks;
import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action to activate a particular guest
 *
 */
public class ActivateGuestAction extends SwitchedAction
{
	/**
	 *@see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		//get info needed
		String guestName = info.getRequestParameter("guestName");

		//Activate image
		ThreadedZVMTasks.ImageActivate thread = new ThreadedZVMTasks.ImageActivate(
				info.threadInfo, guestName);
		thread.startJoinTimeout(Util.TIMEOUT_MS);

		return info.smartForward(thread, Mappings.guests.info.This);
	}

	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		info.setRequestAttribute(Attributes.error.message, "Page not POSTed");
		return info.findForward(Mappings.Global.error);
	}

}
