package live.struts.actions;

import live.threads.ParallelRunner;
import live.threads.ThreadedZVMTasks;

import java.util.LinkedList;
import java.util.ListIterator;

import org.apache.struts.action.ActionForward;

import live.constants.Mappings;
import live.constants.Attributes;

/**
 * Action to activate an entire group
 */
public class ActivateGroupAction extends SwitchedAction
{
	/**
	 * @see live.struts.actions.SwitchedAction#displayPage(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward displayPage(CheckedAction.ActionInfo info)
	{
		String groupName = info.getRequestParameter("groupName");

		info.setRequestAttribute(Attributes.confirmation.message,
				"You are about to activate all the guests in " + groupName
						+ ". Are you sure you wish to proceed?");
		info.setRequestAttribute(Attributes.confirmation.accept_message,
				"Yes, activate group " + groupName);

		return info.findForward(Mappings.guests.deletePage.confirm);
	}
	
	/**
	 * @see live.struts.actions.SwitchedAction#performAction(live.struts.actions.CheckedAction.ActionInfo)
	 */
	public ActionForward performAction(CheckedAction.ActionInfo info)
	{
		//get info needed
		String groupName = info.getRequestParameter("groupName");

		//Get that group.
		LinkedList guestsToActivate = info.cache.getGuestNamesInGroup(groupName);
		
		ParallelRunner activateThreads = new 
			ParallelRunner(info.threadInfo, "Activating group " + groupName,  3);
		
		//Create guest activates threads and add all to the runner.
		ThreadedZVMTasks.ImageActivate actThread;
		ListIterator itr = guestsToActivate.listIterator();
		while(itr.hasNext())
		{
		    actThread = new ThreadedZVMTasks.ImageActivate(info.threadInfo, 
								    (String)itr.next());
		    activateThreads.schedule(actThread);
		}
		
		boolean isDone = activateThreads.startJoinTimeout(Util.TIMEOUT_MS);

		return info.smartForward(activateThreads, Mappings.guests.list.This);
	}
}
