package live.dto;
/**
 * Saved Segment object is used to create and query saved segments
 * on the system
 */
public class SavedSegment
{
    private String name;
    private String startPage;
    private String endPage;
    
    private int intStartPage;
    private int intEndPage;
	    
    /**
     * Constructs a saved segment object 
     *
     * @param name Name of the saved segment
     * @param startPage First page in the saved segment
     * @param endPage Last page in the saved segment
     */
    public SavedSegment(String name, String startPage, String endPage)
    {
	this.name = name;
	this.startPage = startPage;
	this.endPage = endPage;
    }
    
    /**
     * Returns the name
     * 
     * @return String Name of the saved segment
     */
    public String getName()
    {
	return name;
    }
    
    /**
     * Sets the name
     *
     * @param name Name of the saved segment
     */
    public void setName(String name)
    {
	this.name = name;
    }
    
    /**
     * Returns the starting page of a saved segment
     *
     * @return Starting page
     */
    public String getStartPage()
    {
	return startPage;
    }
    
    /**
     * Sets the start page to a specified number
     *
     * @param startPage Start Page
     */
    public void setStartPage(String startPage)
    {
	this.startPage = startPage;
    }
	 
    /**
     * Returns the last page in a saved segment
     *
     * @return Ending page
     */
    public String getEndPage()
    {
	return endPage;
    }
    
    /**
     * Sets the last page to a specified number
     *
     * @param endPage Ending page 
     */
    public void setEndPage(String endPage)
    {
	this.endPage = endPage;
    }
    
    /**
     * Returns the page range for a saved segment
     *
     * @return range of pages
     */
    public String getPageRange()
    {
	return startPage + "-" + endPage;
    }
    
    /**
     * Sets the integer start page
     *
     * @param intStartPage Number to set for start page
     */
    public void setIntStartPage(int intStartPage)
    {
	this.intStartPage = intStartPage;
    }
    
    /**
     * Returns the integer start page
     *
     * @return Number of start page
     */
    public int getIntStartPage()
    {
	return intStartPage;
    }
    
    /**
     * Sets the integer ending page
     *
     * @param intEndPage Number to set for ending page
     */
    public void setIntEndPage(int intEndPage)
    {
	this.intEndPage = intEndPage;
    }
    
    /**
     * Returns the integer ending page
     *
     * @return Number of ending page
     */
    public int getIntEndPage()
    {
	return intEndPage;
    }
}
