/*
 * Group.java Created on June 13, 2005, 7:08 AM
 */
package live.dto;

import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Iterator;

/**
 * Stores the elements of a name list. This is essentially the same as
 * {@link live.dto.Group}, but is made a separate type so as to not muddle the
 * purpose of Group with different uses, because NameLists are not guranteed to
 * have a list of Guest names, just a list of Strings that may or may not have
 * any meaning.
 * 
 * @author Evan Driscoll
 */
public class NameList
{
	private String listName;

	private LinkedList elements;

	/**
	 * Creates a List and sets its name.
	 * 
	 * @param listName The name of this list
	 */
	public NameList(String listName)
	{
		elements = new LinkedList();
		setListName(listName);
	}

	/**
	 * Gets the name of this list.
	 * 
	 * @return Name of this list.
	 */
	public String getListName()
	{
		return listName;
	}

	/**
	 * Sets the name of this group.
	 * 
	 * @param listName The group name to use.
	 */
	public void setListName(String listName)
	{
		this.listName = listName;
	}

	/**
	 * Adds an element to this list.
	 * 
	 * @param elementToAdd The element to add to this list.
	 */
	public void addElement(String elementToAdd)
	{
		elements.add(elementToAdd);
	}

	/**
	 * Returns a ListIterator that can be used to get every element of the list.
	 * Careful of synchronization.
	 * 
	 * @return The ListIterator used to iterate over this list.
	 */
	public ListIterator listIterator()
	{
		return elements.listIterator();
	}

	/**
	 * An iterator into the elements in the list. Careful of synchronization.
	 * 
	 * @return An Iterator into the list of elements
	 */
	public Iterator iterator()
	{
		return elements.iterator();
	}

	/**
	 * Returns the list of elements. Careful of synchronization.
	 * 
	 * @return The list of arguments
	 */
	public LinkedList getElements()
	{
		return elements;
	}

	/**
	 * Returns a readable version of the list in the format:
	 * [List name: [member, member, ...]]
	 * 
	 * @return A string version of NameList in the format above
	 * @see java.lang.Object#toString()
	 */
	public String toString()
	{
		StringBuffer sb = new StringBuffer();

		sb.append("[List ").append(getListName()).append(": ");
		sb.append(getElements().toString()).append("]");

		return sb.toString();
	}
}
