
package live.dto;

/**
 * Stores all the information about minidisks (used for cloning)
 * @author Emily Celeskey
 */
public class MDisk
{
    private String virtAddr;
    private String storageType;//AUTOG or T-DISK or V-DISK
    private String startNum;
    private String amt;
    private String volumeID;
    private String mode;
    private boolean PW;
    private String ReadPW;
    private String WritePW;
    private String MultiPW;
    private String blockOrCylinder;
    
    /**
     * Creates a new instance of MDisk 
     *
     * @param virtAddr virtual address of the minidisk
     * @param storageType what kind of storage for this minidisk - AUTOG, T-DISK, V-DISK
     * @param startNum starting number for DASD
     * @param amt how much DASD to allocate
     * @param volumeID which volume to allocate DASD on, usually LVDASD
     * @param mode Access mode for the DASD
     * @param PW Whether passwords have been set for the DASD or not
     * @param ReadPW Read access password
     * @param WritePW Write access password
     * @param MultiPW Multi access password
     * @param BlockOrCylinder whether it is being stored as a block or a cylinder
     *
     */
    public MDisk(String virtAddr, String storageType, 
    		String startNum, String amt, String volumeID, String mode, 
			boolean PW, String ReadPW, String WritePW, String MultiPW, String BlockOrCylinder)
    {
	    this.setVirtAddr(virtAddr);
	    this.setStartLoc(startNum);
	    this.setSize(amt);
	    this.setVolumeID(volumeID);
	    this.setMode(mode);
	    this.setAllocationType(storageType);
	    this.setHasPW(PW);
	    this.setReadPW(ReadPW);
	    this.setWritePW(WritePW);
	    this.setMultiPW(MultiPW);
	    this.setBlOrCyl(BlockOrCylinder);
    }
    public MDisk()
    {
	this.setVirtAddr(null);
	this.setStartLoc(null);
	this.setSize(null);
	this.setVolumeID(null);
	this.setMode(null);
	this.setAllocationType("AUTOG");
	this.setHasPW(false);
	this.setReadPW(" ");
	this.setWritePW(" ");
	this.setMultiPW(" ");
	this.setBlOrCyl("CYLINDERS");
    }
	/**
	 * Sets the virtual address of the disk
	 *
	 * @param virtAddr The virtAddr to set.
	 */
	public void setVirtAddr(String virtAddr)
	{
		this.virtAddr = virtAddr;
	}
	/**
	 * Returns the virtual address of the disk
	 *
	 * @return Returns the virtAddr.
	 */
	public String getVirtualAddr()
	{
		return virtAddr;
	}
	
	/**
	 * Sets the storage type
	 *
	 * @param storageType The storageType to set.
	 */
	public void setAllocationType(String storageType)
	{
		this.storageType = storageType;
	}
	
	/**
	 * Returns the storage type
	 *
	 * @return Returns the storageType.
	 */
	public String getAllocationType()
	{
		return storageType;
	}
	/**
	 * Sets the starting cylinder or block number
	 *
	 * @param startNum The startNum to set.
	 */
	public void setStartLoc(String startNum)
	{
		this.startNum = startNum;
	}
	/**
	 * Returns the starting cylinder or block number
	 *
	 * @return Returns the startNum.
	 */
	public String getStartLoc()
	{
		return startNum;
	}
	/**
	 * Sets the volume ID
	 *
	 * @param volumeID The volumeID to set.
	 */
	public void setVolumeID(String volumeID)
	{
		this.volumeID = volumeID;
	}
	/**
	 * Returns the volume ID
	 *
	 * @return Returns the volumeID.
	 */
	public String getVolumeID()
	{
		return volumeID;
	}
	/**
	 * Sets the access mode
	 *
	 * @param mode The mode to set.
	 */
	public void setMode(String mode)
	{
		this.mode = mode;
	}
	/**
	 * Returns the access mode
	 *
	 * @return Returns the mode.
	 */
	public String getMode()
	{
		return mode;
	}
	/**
	 * Sets the read access PW
	 *
	 * @param readPW The readPW to set.
	 */
	public void setReadPW(String readPW)
	{
		ReadPW = readPW;
	}
	/**
	 * Returns the read access PW
	 *
	 * @return Returns the readPW.
	 */
	public String getReadPW()
	{
		return ReadPW;
	}
	/**
	 * Sets the write access PW
	 *
	 * @param writePW The writePW to set.
	 */
	public void setWritePW(String writePW)
	{
		WritePW = writePW;
	}
	/**
	 * Returns the write access PW
	 *
	 * @return Returns the writePW.
	 */
	public String getWritePW()
	{
		return WritePW;
	}
	/**
	 * Sets the multi access PW
	 *
	 * @param multiPW The multiPW to set.
	 */
	public void setMultiPW(String multiPW)
	{
		MultiPW = multiPW;
	}
	/**
	 * Returns the multi access PW
	 *
	 * @return Returns the multiPW.
	 */
	public String getMultiPW()
	{
		return MultiPW;
	}
	/**
	 * Sets the PW variable
	 *
	 * @param pW Whether passwords have been set.
	 */
	public void setHasPW(boolean pW)
	{
		PW = pW;
	}
	/**
	 * Returns the value of the PW boolean
	 * @return Returns whether passwords have been set.
	 */
	public boolean hasPW()
	{
		return PW;
	}
	/**
	 * @param amt The amt to set.
	 */
	public void setSize(String amt)
	{
		this.amt = amt;
	}
	/**
	 * @return Returns the amt.
	 */
	public String getSize()
	{
		return amt;
	}
	/**
	 * @param blockOrCylinder Whether we're using blocks or cylinders
	 */
	public void setBlOrCyl(String blockOrCylinder)
	{
	    this.blockOrCylinder=blockOrCylinder;
	}
	/**
	 * @return Returns whether we're using blocks or cylinders
	 */
	public String getBlOrCyl()
	{
	    return blockOrCylinder;
	}
    
}
