/*
 * Guest.java
 * Created on June 10, 2005, 2:54 PM
 */

package live.dto;

/**
 * Guest is used by the cache to store information about a specific guest.
 * @author Jason J. Herne
 */
public class Guest
{
    private String guestName;
    private String groupName;
    
    private String permissionClasses;
    private String initMem;
    private String maxMem;
    
    /**
     * Creates a guest, setting its name and group name.
     *
     * @param guestName Name of this guest.
     * @param groupName Name of group this guest belongs to.
     */
    public Guest(String guestName, String groupName)
    {
	setGuestName(guestName);
	setGroupName(groupName);
    }
    
    /**
     * Creates a guest, setting its name.  Its group is set to null.
     *
     * @param guestName Name of this guest.
     */
    public Guest(String guestName)
    {
	setGuestName(guestName);
	setGroupName(null);
    }
    
    /**
     * Sets the guest name of this guest object.
     *
     * @param guestName The name of this guest.
     */
    public void setGuestName(String guestName)
    {
	this.guestName = guestName;
    }
    
    /**
     * Gets the name of this guest.
     *
     * @return The name of this guest. 
     */
    public String getGuestName()
    {
	return guestName;
    }
    
    /**
     * Sets the group name of this guest object.
     *
     * @param groupName The name of group this guest belongs to.
     */
    public void setGroupName(String groupName)
    {
	this.groupName = groupName;
    }
    
    /**
     * Gets the name of the group this guest belongs to.
     *
     * @return Name of the group this guest belongs to.
     */
    public String getGroupName()
    {
	return groupName;
    }
    
    /**
     * Tests if two guests have the same name. It ignores the group and
     * all other parameters!
     * 
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object b)
    {
    	if(b instanceof Guest && ((Guest) b).guestName.equals(this.guestName))
    		return true;
   		return false;
    }
    
    /**
     * Returns the hash code
     * 
     * @return Hash code
     */
    public int hashCode()
    {
    	return guestName.hashCode();
    }
    
    /**
     * Returns a readable description of the guest in the form
     * guest name: group name
     * 
     * @return GuestName: groupName
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
    	return guestName + ": " + groupName;
    }

	/**
	 * @param permissionClasses The permissionClasses to set.
	 */
	public void setPermissionClasses(String permissionClasses)
	{
		this.permissionClasses = permissionClasses;
	}

	/**
	 * @return Returns the permissionClasses.
	 */
	public String getPermissionClasses()
	{
		return permissionClasses;
	}

	/**
	 * Sets the initial memory (storage) size.
	 * 
	 * @param initMem The initial memory size to set.
	 */
	public void setInitMem(String initMem)
	{
		this.initMem = initMem;
	}

	/**
	 * Gets the initial memory (storage) size.
	 * 
	 * @return Returns the initial memory size.
	 */
	public String getInitMem()
	{
		return initMem;
	}

	/**
	 * @param maxMem The maxMem to set.
	 */
	public void setMaxMem(String maxMem)
	{
		this.maxMem = maxMem;
	}

	/**
	 * @return Returns the maxMem.
	 */
	public String getMaxMem()
	{
		return maxMem;
	}
}
