package live.dto;

/**
 * This class holds information about how to connect to the SMAPI server.
 * It's stored in each session inside a {@link live.threads.ThreadInitInfo}
 * object.
 *  
 * @author Evan Driscoll
 */
public class ConnectionInfo
{
	private String userName;
	private String password;
	private String hostName;
	private int portNo;

	/**
	 * Constructs a ConnectionInfo that will login to the specified server
	 * with the specified user name and password. The user name and password
	 * are intended to be set in the login action to whatever the user entered,
	 * and specifiy what will be sent in all the SMAPI calls. 
	 * 
	 * @param host The host name or IP address to connect to
	 * @param port The port to connect on
	 * @param user The user name to send SMAPI calls as
	 * @param pass The password to send with SMAPI calls
	 */
	public ConnectionInfo(String host, int port, String user, String pass)
	{
		userName = user;
		password = pass;
		hostName = host;
		portNo   = port;
	}
	
	/** 
	 * Gets the userName
	 * @return String user name
	 */
	public String getUserName() { return userName; }

	/** 
	 * Gets the password
	 * @return String Password
	 */
	public String getPassword() { return password; }
	
	/**
	 * Gets the host name or IP address
	 * @return String host name
	 */
	public String getHostName() { return hostName; }
	
	/**
	 * Gets the port number
	 * @return int port number
	 */
	public int    getPort()     { return portNo;   }
}
