package live.constants;

/**
 * Mappings are very similar to {@link live.constants.Attributes}, but somewhat
 * from the other direction. Mappings represents valid responses of actions of
 * where to go next. Each constant then is a forward that should correspond to
 * those in struts-config.
 * 
 * All [actually most] also contain a "This" forward which will forward to the
 * page (action, really) in question. So while, for instance, you would use
 * {@link Mappings.guests.list#OK} from the action ListGuestAction (called from
 * URI /Guests/List.page) if everything is hunky dory, you would use
 * <tt>Mappings.guests.list.This</tt> from another action that should go to
 * the guest list when complete.
 * 
 * As with {@link live.constants.Attributes}, theres a special case, though
 * these are better structured. There is also a {@link Attributes.Global}class
 * that holds forwards that are used in many or all actions, but this time all
 * the specific classes inherit from it. For instance, the timeout page is
 * located in <tt>Global</tt> and inherited by almost every other action.
 * 
 * @author Evan Driscoll
 */
public final class Mappings
{
	/** Forwards that are used from many actions */
	public static class Global
	{
		/** Session timed out, reauthenticate */
		public static final String reauthenticate = "Reauthenticate";
		
		/** Confirm the current action. (Will POST to current URL if accepted) */
		public static final String confirm = "ConfirmPage";
		
		/** Action timed out */
		public static final String timeout = "Timeout";
		
		/** There was an error */
		public static final String error = "ErrorPage";
	}
	
	/** Forwards from the login action */
	public static final class login extends Global
	{
		/** Login is OK, show the frames */
		//public static final String OK  = "LoginOK";
	}
	
	/** Forwards from the status action */
	public static final class status extends Global
	{
		/** Show the general status page */
		public static final String General  = "general";
		
		/** Show the specifc status page */
		public static final String Specific  = "specific";
		
		public static final String bad = "Bad"; 
	}
	
	/** Forwards from actions called from /Networks/ URIs */
	public static final class networks
	{
		/** Forwards from the network list action */
		public static final class list extends Global
		{
			public static final String This = "Networks_List";
			public static final String OK   = "ListNetworks";
		}
		
		/** Forwards from the new network action */
		public static final class newPage extends Global
		{
			public static final String This = "Networks_New";
			public static final String DisplayPage   = "DisplayPage";
		}
		
		/** Forwards from the delete network action (uses confirm and a This) */
		public static final class deletePage extends Global
		{
			public static final String This = "Networks_Delete";
		}
		
		/** Forwards from the network info action */
		public static final class info extends Global
		{
			public static final String This = "Networks_Info";
			public static final String OK   = "NetworkInfo";
		}
		
		/** Forwards from the change network members action */
		public static final class chMembers extends Global
		{
			public static final String DisplayPage = "ShowPage";
		}
	}
	
	/** Forwards from actions called at /Guests/ URIs */
	public static final class guests
	{
		/** Forwards from the guest list action */
		public static final class list extends Global
		{
			public static final String This = "Guests_List";
			public static final String OK   = "ListGuests";
		}
		
		/** Forwards from the guest info action */
		public static final class info extends Global
		{
			public static final String This = "Guests_Info";
			public static final String OK   = "GuestInfo";
		}
		
		/** Forwards from the guest delete action (uses confirm and a This) */
		public static final class deletePage extends Global
		{
			public static final String This = "Guests_Delete";
		}
		
		/** 
		 * Forwards from the action that will change a single guest's
		 * group.
		 */ 
		public static final class chGuestsGroupPage extends Global
		{
			public static final String This = "Guests_ChangeGuestsGroup";
			public static final String list = "ShowList";
			public static final String done = "Done";
		}
		
		/** Forwards from the delete group action */
		public static final class deleteGroup extends Global
		{
			//public static final String This
			public static final String OK = Mappings.guests.list.This;
		}
		
		/** Forwards from the destroy group action */
		public static final class destroyGroup extends Global
		{
			//public static final String This
			public static final String notPosted = "ErrorPage";
		}

		/** Forwards from the new group action */ 
		public static final class newGroup extends Global
		{
			public static final String This = "/Guests/NewGroup.page";
			public static final String showForm = "showForm";
		}
		
		/** Forwards from the new guest action */
		public static final class newGuest extends Global
		{
			public static final String showForm = "showForm";
		}
		
		public static final class clone extends Global
		{
			public static final String showPage = "ShowPage";
		}
		
		public static final class activate extends Global
		{
		}
		
		public static final class deactivate extends Global
		{
		}
		
		public static final class activateGroup extends Global
		{
		}
		
		public static final class deactivateGroup extends Global
		{
		}
		
		public static final class chMinidisks extends Global
		{
		}
		
		public static final class chPass extends Global
		{
			public static final String showPage = "showPage";
		}
		
		public static final class ViewMinidisks extends Global
		{
			public static final String showPage = "showPage";
		}
		
		public static final class chMem extends Global
		{
			public static final String showPage = "ShowPage";
		}
	}
	
	/**
	 * I have NO idea if any of this is right! */
	public static final class sharedSegments
	{
	    public static final class list extends Global
	    {
		public static final String This = "/SharedMem/List.page";
		public static final String OK = "ListSharedMem";
	    }
	    
	    public static final class newseg extends Global
	    {
		public static final String This = "/SharedMem/NewSharedMem.page";
		public static final String OK = "NewSharedMem";
	    }
	    
	    public static final class info extends Global
	    {
		public static final String This = "/SharedMem/Info.page";
		public static final String OK = "InfoSharedMem";
	    }
	    
	    public static final class delete extends Global
	    {
		public static final String This = "/SharedMem/Delete.page";
	    }
	    
	    public static final class chMembers extends Global
	    {
		public static final String This = "/SharedMem/ChMembers.page";
		public static final String DisplayPage = "DisplayPage";
	    }
	    
	    
	}
}
