package live.constants;

/**
 * The Attributes class holds String constants that are mostly used (with
 * exceptions as below) by the JSP pages to display information. The
 * organization is as follows.
 * 
 * There are a number of nested classes in this that correspond to directories
 * in the file system or files. For instance, the class
 * {@link Attributes.networks.list}holds attributes that are used by the JSP
 * page networks/list.jsp. If you were going to forward to that page, you must
 * set the attribute <tt>networks.list.vswitches</tt> (<tt>networks.list.glans</tt>
 * too if the tool supported guest LANs) before forwarding. Any attributes ending
 * with _OPT are optional, and if omitted the JSP page will display without error.
 * 
 * (TODO: Unfortunately, this won't tell you what type of object is expected or 
 * anything like that. What would be nice is if you could make a full-fledged
 * object for each page with a number of setAttribute methods that would be
 * typed. e.g., there would be a method setVSwitchList(LinkedList) in the
 * networks.list class. Then there would be a forward() method that would return
 * an ActionForward to that page.) 
 * 
 * 
 * The two classes {@link guestList}, and {@link Global}also correspond this
 * way, but are used slightly differently. <tt>Global</tt> holds attributes
 * that are common to all pages, but no Global.jsp exists. (TODO: Ideally then,
 * all pages would inherit from Global.) <tt>guestList</tt> holds attributes
 * that are used by guestList.jsp. However, this page is never actually loaded
 * expliticly, only included in other pages. Thus rather than refer to the
 * constants in <tt>guestList</tt> itself, you should make pages that include
 * it extend <tt>guestList</tt> and refer to the then-inherited attributes in
 * that class. (See {@link networks.newPage} for an example.) 
 * 
 * The remaining two class are {@link servletContext}and {@link session}.
 * <tt>servletContext</tt> holds attributes where actions can retrieve stuff
 * like the current cache object and the cacheThread. <tt>session</tt> is
 * where actions can retrieve session-specific attributes such as the thread
 * info object.
 * 
 * @author Evan Driscoll
 */
public final class Attributes
{
	/**
	 * Holds attribute names containing information that should be shared across
	 * sessions. These are attributes in the servlet context. For instance, to
	 * get the Cache object, you would use 
	 * <tt>request.getServletContext().getAttribute(Attributes.servletContext.cache)</tt>
	 */
	public static final class servletContext
	{
		public static final String cache = "Cache";
		public static final String cacheThread = "CacheThread";
	}
	
	/**
	 * Holds attribute names containing information that should be shared across
	 * requests, but not across sessions. These are attributes in the session
	 * object. For instance, to get the threadInfo object, you would use:
	 * <tt>request.getSession().getAttribute(Attributes.session.threadInfo)</tt>
	 */
	public static final class session
	{
		public static final String threadInfo = "threadInitInfo";
	}
	
	/**
	 * Holds attribute names expected by the guestList. Don't use this class
	 * directly. Instead, for each JSP that includes guestList.jsp, make the
	 * corresponding Attribute class inherit from this.
	 */
	public static class guestList
	{
		/** A Collection of {@link live.dto.Group} objects */
		public static final String groupList = "guestList";
		
		/**
		 * A {@link java.util.Set}of Strings of guest names that should be
		 * checked by default.
		 */
		public static final String checkByDefault_OPT = "checkedSet";
	}
	
	/**
	 * Attributes for shared segments list page.
	 */
	public static final class sharedSegmentsList
	{
	    /** LinkedList of all shared segments */
	    public static final String segments = "segments";
	}
	
	/**
	 * Attributes for shared segments new page.
	 */
	public static final class sharedSegmentsNew
	{
	    public static final String groups = "guestList";
	}
	
	/**
	 * Holds attributes common to all pages.
	 */
	public static final class Global
	{
		public static final String recentlyCompleteThreads = "recentlyCompleteThreads";
	}

	/**
	 * Request attributes expected by the error page
	 */
	public static final class error
	{
		/** A string to be displayed as the error */
		public static final String message = "errorMessage";
	}
	
	/** This is an attribute expected by the logon ACTION */
	public static final class login
	{
		public static final String forwardTo_OPT   = "forwardMapping";
		//public static final String queryString = "queryString";
	}
	
	/**
	 * Attributes expected by the status pages.
	 */
	public static final class status
	{
		public static final class general
		{
			public static final String threadList = "threadList";
		}
		
		public static final class specific
		{
			public static final String taskItemList_OPT = "TaskItemList";
		}
	}
	
	/**
	 * Attributes expected by the confirmation page
	 */
	public static final class confirmation
	{
		/** The warning to display to the user. (The main message.) */
		public static final String message = "warningMessage";

		/** The text of the accept link/button */
		public static final String accept_message = "acceptMessage";
	}
	
	/** Network pages */
	public static final class networks
	{
		/** Request attributes expected by the list page */
		public static final class list
		{
			/** A Collection of Network DTOs */
			public static final String vswitches = "vswitchList";
			//public static final String glans     = "glanList";
		}
		
		/** Attributes expected by the new network page */
		public static final class newPage extends guestList
		{
			
		}
		
		/** Attributes expected by the network info page */
		public static final class info
		{
			/** A String with teh network's name */
			public static final String name = "networkName";
			
			/** A Collection of Strings that are members */
			public static final String members = "members";
		}
		
		/** Attributes expected by the change network members page */
		public static final class chMembers extends guestList
		{
			
		}
	}
	
	/** Pages relating to guests and groups */
	public static final class guests
	{
		/** Attributes expected by the guest/group list page */
		public static final class list
		{
			/** A Collection of {@link live.dto.Group}s */ 
			public static final String groups = "guestList";
			
			/** 
			 * A {@link java.util.Set} containing images that should be marked
			 * as active.
			 */
			public static final String active_set_OPT = "activeImages";
		}
		
		/** Attributes expected by the guest info page. */
		public static final class info
		{
			/** A String that's the name of the guest being viewed */
			public static final String name   = "guestName";
			
			/** A String that's the name of the group the guest belongs to */
			public static final String group  = "groupName";
			
			/** A String equal to either "true" or "false" */
			public static final String active = "active";

			/** A String that's the guest's default amount of storage */
			public static final String storage    = "defaultRAM";
			
			/** A String that's the guest's maximum amount of storage */
			public static final String maxStorage = "maxRAM";
			
			/** A String that's the guest's permission classes */
			public static final String classes    = "userClasses";
		}
		
		/** 
		 * Attributes expected by the page that changes a single guest's group
		 * (as opposed to changing the guests that are in a single group). 
		 * */
		public static final class changeGuestsGroup
		{
			/** A Collection of Strings that are group names */
			public static final String guestList = "groupList";
			
			/** A String that is the current group */
			public static final String currentGroup = "currentGroup";
			
			/** A String that is the name of the guest that's being changed */
			public static final String guestname = "guestName";
		}
		
		/**
		 * Attributes expected by the newGroup page. (This is the same page that
		 * is used for changing a group's members.)
		 */
		public static final class newGroup extends guestList
		{
			
		}
		
		/**
		 * Attributes expected by the new guest page.
		 */
		public static final class newGuest
		{
			public static final String groupList = "groupList";
		}
		
		/**
		 * Attributes expected by the new guest page.
		 */
		public static final class chMinidisks
		{
			public static final String diskList = "diskList";
		}
	} // class guests
}
