/* 
 * dynamo.h
 **/

/* Error Codes */
//#define DEBUG 1
#define RC_OK 0
#define PASSWORD_ERROR  4       /* return code error on password        */
#define COMMAND_ERROR   5       /* return code error on command         */
#define SOCKET_ERROR    6       /* return code error on socket          */
#define CONNECT_ERROR   7       /* return code error on connect         */
#define SEND_ERROR      8       /* return code error on send            */
#define CLOSE_ERROR     9       /* return code error on return          */
#define SERVER_ERROR    10      /* return code error on server          */
#define STORAGE_ERROR   11      /* return code error on find storage    */
#define SIZEFILE_ERROR  12      /* return code error on size file       */
#define PREPARECONTENT_ERROR 13 /* return code error on prepare content */
#define COPYDATA_ERROR  14      /* return code error on copy data       */
#define QUERY_ERROR     15      /* return code error on query           */
#define FILE_ERROR      16      /* return code error on file open       */
#define AUTHENTICATION_ERROR 17 /* return code error on authentication  */
#define NOTFOUND_ERROR  18	/* return code error on DCSS Not Found  */
#define REMOVE_ERROR    19	/* return code error on remove dcss     */
#define CREATE_ERROR    20      /* return code error on create dcss	*/
#define NAME_ERROR      21	/* return code error on dcss name 	*/
#define NONAME_ERROR    22  	/* return code error on no dcss name    */
#define NODCSS_ERROR	23	/* return code error on no dcss to query*/
#define UPDATE_ERROR    24	/* return code error on update 		*/
#define CONFIG_ERROR    25	/* return code error on config          */

#define SMAPI_PORT 44444
#define MAX_BUFFER_SIZE 256

#define CRT 1
#define UPD 2
#define REM 3
#define QUE 4
#define RST 5
#define DLU 6
#define ADU 7
#define QUS 8

static char DELM[1] = {'\0'};
static char use_gaps[5] = {"TRUE"};

static char DCSSFILE[6] = {".dcss"};
static char SIZEFILE[11] = {"dmosize.txt"};
static char CONFIGFILE[14] = {"dynamo.config"};
static char DMOTEMP[8] = {"dmotemp"};

/* SMAPI Commands */
static char SSSFNDST[9] = {"SSSFNDST"}; /* Find Storage                         */
static char SSSMEMC2[9] = {"SSSMEMC2"}; /* Create empty DCSS                    */
static char SSSMEMRS[9] = {"SSSMEMRS"}; /* Create restricted DCSS               */
static char DMSCSSSC[9] = {"DMSCSSSC"}; /* SMAPI Shared Storage Create          */
static char DMSCSSSD[9] = {"DMSCSSSD"}; /* SMAPI Shared Storage Delete          */
static char DMSCSSSQ[9] = {"DMSCSSSQ"}; /* SMAPI Shared Storage Query           */
static char SSSMEMAN[9] = {"SSSMEMAN"}; /* SMAPI Shared Storage Access Add      */
static char SSSMEMDN[9] = {"SSSMEMDN"}; /* SMAPI Shared Storage Access Delete   */
static char SSSMEMDL[9] = {"SSSMEMDL"}; /* SMAPI Shared Storage Delete          */
static char SMAPI_NULL[7] = {"SSSTRY"}; /* SMAPI Null for Authentication        */

/* DynaMO Commands */
static char CREATE[9] = {"create"};
static char UPDATE[9] = {"update"};
static char REMOVE[9] = {"remove"};
static char QUERY[9] = {"query"};
static char RESTRICT[9] = {"restrict"};
static char DELUSER[9] = {"deluser"};
static char ADDUSER[9] = {"adduser"};
static char QRYUSERS[9] = {"qryusers"};

/* DCSS Access Types */
static char SN[3] = {"SN"};
static char SR[3] = {"SR"};
static char EW[3] = {"EW"};
static char EN[3] = {"EN"};
static char ER[3] = {"ER"};
static char SC[3] = {"SC"};
static char* TYPES[6] = { SN,SR,EW,EN,ER,SC};

/* special DCSS type just for dynamo */
static char FI[3] = {"FI"};

/* Error Message and Output Prototypes */
void msg0(FILE *stream, int n);
void msg1(FILE *stream, int n, char *p1);
void msg2(FILE *stream, int n, char *p1, char *p2);
void msg3(FILE *stream, int n, char *p1, char *p2, char *p3);
void output0(FILE *stream, int n);
void output1(FILE *stream, int n, char *p1);

/* DynaMO Manager Function Prototypes */
void append_buffer(char *buffer_ptr, char *src, int *buffer_size);
int authenticate_user(char *userid, char* password);
int call_smapi(char *buffer, int buffer_size, int *rs, char *return_buffer);
int choose_location(char*, char*, char*);
int create_formatted(char *dcssname, char *filename);
int create_segment(char *dcssname,char *page_range, char *access_type, int rstd);
int create_unformatted(char *dcssname,char *size, char *access_type);
int copy_data(char *dcssname);
void obtain_userid(char *name);
int prepare_content(char *filename, char *dcss_size);
int query_dcss(char *dcssname);
int remove_dcss(char *dcssname);
int add_dcssname(char *dcssname);
int query();
int umount_dcss(char *dcssname);


/* DynaMO Error Messages */
static char *MESSAGES[] = {
/* 0 */	 			"DynaMO Manager Operation Successful.\n",
/* 1 */				" ",
/* 2 */				" ",
/* 3 */				" ",
/*PASSWORD_ERROR  4 */		"Incorrect Password. Please try again. Error: %s\n",
/*COMMAND_ERROR   5 */		"Invalid Command. Valid DynaMO Manager commands are: create, update, query, and remove. Error: %s\n",
/*SOCKET_ERROR    6 */		"Unable to connect to the server. Check your system management server and try again. Error: %s\n",
/*CONNECT_ERROR   7 */		"Unable to connect to the server. Check your system management server and try again. Error: %s\n",
/*SEND_ERROR      8 */		"Unable to communicate with the server.  Check your connection and try again. Error: %s\n",
/*CLOSE_ERROR     9 */		"Communication error with the server.  Check your connection and try again. Error: %s\n",
/*SERVER_ERROR    10*/		"Server error.  Check your connection and try again. Error: %s\n",
/*STORAGE_ERROR   11*/		"z/VM Memory Error.  Unable to create a memory object of this size. Error: %s\n",
/*SIZEFILE_ERROR  12*/		"DynaMO Manager Error.  Please try again. Error: %s\n",
/*PREPARECONTENT_ERROR 13 */    "Formatting Error.  Please verify your .dmo formatting file. Error: %s\n",
/*COPYDATA_ERROR  14*/		"Copy Error. Please verify your .dmo formating file and that the DCSS Block Device Driver is available on your linux guest. Error: %s\n",
/*QUERY_ERROR     15*/		"Query Error. Error: %s\n",
/*FILE_ERROR      16*/ 		"Unable to find file .dcss Error: %s\n",
/*AUTHENTICATION_ERROR 17 */	"User not authorized for DynaMO. Error: %s\n",
/*NOTFOUND_ERROR  18*/          "DCSS does not exist. Error: %s\n",
/*REMOVE_ERROR    19*/		"DCSS could not be removed. Error: %s\n",
/*CREATE_ERROR    20*/		"DCSS could not be created. Error: %s\n",
/*NAME_ERROR      21*/		"DCSS names must be eight characters or less. Error: %s\n",
/*NONAME_ERROR    22*/		"You must specify a name for this command. Error: %s\n",
/*NODCSS_ERROR    23*/		"DynaMO Manager has no DCSS's to manage. Error: %s\n",
/*UPDATE_ERROR    24*/		"Unable to update the DCSS. Error: %s\n",
/*CONFIG_ERROR    25*/		"Unable to configure the server. Error: %s\n",
/*  */				" "
				};

static char *OUTPUT[] = {
/* 0 */				" ",
/* 1 */				"FILE FILENAME FILETYPE MINSIZE  BEGPAG ENDPAG TYPE CL #USERS PARMREGS VMGROUP\n",
/* 2 */				"Creating the DCSS...\n",
/* */				" "
				};
